typedef struct TagCHATDATA {
  int     Head, Tail;
  int     BufSz;
  ULONG   Index;               // index is 1-based
  //CRITICAL_SECTION  CSect;
  HANDLE  CSect;
  char*   Buf;
} CHATDATA;


// low-level chat room operations

extern void LockRoom( CHATDATA* Room );
extern void UnlockRoom( CHATDATA* Room );
extern void AddChatMessage( CHATDATA* Room, char* Msg );
extern void GetChatMessage( CHATDATA* Room,
                     ULONG Index, // if index 0, all msgs
                     STRINGLIST* Result );
extern void ClearRoom( CHATDATA* Room );
extern BOOL InitRoom( CHATDATA* Room, int BufSz );
extern void DeinitRoom( CHATDATA* Room );
extern BOOL InitChat();
